 ; Ŀ
 ;   Rloadt - make a self-loading function of a lisp routine, includes     
 ;   logging of loaded routines to Trend.txt in the Acad base directory.   
 ;   Copyright 1994, 2005 by Rocket Software Ltd.                          
 ;   Preload lisp files without wasting time or memory.                    
 ;   Allows loading a routine from a file not named after it, or loading   
 ;   of several routines from one file when any one of them is called:     
 ;   (rload "filename" '("lisp1" "lisp2" ... ).                            
 ;   Note that Rloadt is essentially free-standing - Trende and all its    
 ;   subroutines are add-ons for tracking lisp load frequency.             
 ;   See also Rload, which is the same thing without logging.              
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Alphls - put a list in order alphabetically by the first   
 ;   string in each sublist.                                               
 ;   Arguments: Alist, a list.                                             
 ;   Returns the list in order.                                            
 ; 
 (DEFUN ALPHLS (alist / num sub blist stra gnulst alistb len clist)
 ; Ŀ
 ;   Make a list, blist, of all the first elements (strings) in alist.     
 ; 
  (setq num 0)
  (while (setq sub (nth num alist))
         (setq num (1+ num))
         (setq blist (cons (car sub) blist)))
 ; Ŀ
 ;   Alphabetise blist.                                                    
 ; 
  (setq blist (acad_strlsort blist))
 ; Ŀ
 ;   For each element in blist, find the matching sublist in alist,        
 ;   remove it from alist and add it to gnulist.                           
 ; 
  (setq num 0)
  (while (setq stra (nth num blist))
         (setq num (1+ num))
         (setq sub (assoc stra alist))
         (setq gnulst (cons sub gnulst))
         (setq alistb (cdr (member sub alist)))
         (setq len (1+ (length alistb)))
         (setq clist (reverse alist))
         (repeat len (setq clist (cdr clist)))
         (setq alist (append (reverse clist) alistb)))
 (reverse gnulst))
 ; Ŀ
 ;   Alphls end.                                                           
 ; 

 ; Ŀ
 ;   Bulla - write a list of lists to a csv file.                          
 ;   Arguments: Lista, a list.                                             
 ;              Filnam, a filename.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN BULLA (lista filnam / fn sub str nxtstr)
  (setq fn (open filnam "w"))
  (while (setq sub (car lista))
         (setq lista (cdr lista))
         (setq str "")
         (while (setq nxtstr (car sub))
                (setq sub (cdr sub))
                (setq str (strcat str "," nxtstr)))
         (write-line (substr str 2) fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Bulla end.                                                            
 ; 

 ; Ŀ
 ;   Coduft - suck a cdf file into a list.                                 
 ;   Arguments: filnam, a filename.                                        
 ;   Calls Csplit.                                                         
 ;   Returns a list of lists of strings.                                   
 ; 
 (DEFUN CODUFT (filnam / fn linn llist num gnulis suba malist)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (if (/= linn "")
                      (progn
                           (setq llist (csplit linn))
 ; Ŀ
 ;   Decapitalize the list (i.e. all substrings.)                          
 ; 
                           (setq num 0)
                           (setq gnulis ())
                           (while (setq suba (nth num llist))
                                  (setq suba (strcase suba t))
                                  (setq num (1+ num))
                                  (setq gnulis (cons suba gnulis)))
                           (setq gnulis (reverse gnulis))
                           (setq malist (append malist (list gnulis))))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Coduft end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Sohrt - sort a list of lists (("aaa" "n") ...) into order by n.       
 ;   Arguments: Lista, a list.                                             
 ;   Returns the list in order.                                            
 ;   Calls Alphls.                                                         
 ; 
 (DEFUN SOHRT (lista / num sub numa hinum lonum ordlst asocn gnulis)
 ; Ŀ
 ;   Find the highest and lowest number in the list lista.                 
 ; 
  (setq num 0)
  (while (setq sub (nth num lista))
         (setq num (1+ num))
         (setq numa (read (cadr sub)))
         (if (or (null hinum) (> numa hinum))
             (setq hinum numa))
         (if (or (null lonum) (< numa lonum))
             (setq lonum numa)))
 ; Ŀ
 ;   Make an ordered list (ordlst) of all numbers between hinum and lonum. 
 ; 
  (while (<= lonum hinum)
         (setq ordlst (cons (list lonum) ordlst))
         (setq lonum (1+ lonum)))
; (setq ordlst (reverse ordlst)) ; remove leading semicolon to sort forward
 ; Ŀ
 ;   Add each sub in numlst to the appropriate sublist in ordlst.          
 ; 
  (setq num 0)
  (while (setq sub (nth num lista))
         (setq num (1+ num))
         (setq asocn (assoc (read (cadr sub)) ordlst))
         (setq ordlst (subst (append asocn (list sub)) asocn ordlst)))
 ; Ŀ
 ;   Make the whole thing back into a list, ditching the initial numbers.  
 ; 
  (setq num 0)
  (while (setq sub (nth num ordlst))
         (setq num (1+ num))
         (if (> (length sub) 1)
             (progn
                  (if (> (length sub) 2)             ; call alphls to sort
                      (setq sub (alphls (cdr sub)))
                      (setq sub (cdr sub)))
                  (setq gnulis (append gnulis sub)))))
 gnulis)
 ; Ŀ
 ;   Sohrt end.                                                            
 ; 

 ; Ŀ
 ;   Spath - split a path and filename string into a path and a filename.  
 ; 
 (DEFUN SPATH (tt / pos pp)
 ; Ŀ
 ;   Set the pointer Pos to the end of the string.                         
 ; 
  (setq pos (strlen tt))                            ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq pp (substr tt 1 pos))      ; then set pp to all before
                   (setq tt (substr tt (1+ pos)))   ;          tt to all after
                   (setq pos 1)))                   ;      and pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 (list pp tt))
 ; Ŀ
 ;   Spath end.                                                            
 ; 

 ; Ŀ
 ;   Trende - update a lisp load trend file.                               
 ;   Arguments: Lispnm, a lisp name.                                       
 ;   Calls numerous things, returns nothing.                               
 ; 
 (DEFUN TRENDE (lispnm / filnam comlst found num sub gnulst)
  (setq lispnm (strcase lispnm t))
 ; Ŀ
 ;   Find the trend.txt file in c:\etc\acad or make a new one.             
 ; 
  (if (not (setq filnam (findfile "trend.txt")))
      (setq filnam (strcat (car (spath (findfile "acad.exe"))) "Trend.txt")))
 ; Ŀ
 ;   Read the file into a list.                                            
 ; 
  (if (setq comlst (coduft filnam))
      (progn
           (setq num 0)
 ; Ŀ
 ;   Check each sublist to see if it contains the current lisp name,       
 ;   if so then increment the number.                                      
 ; 
           (while (setq sub (nth num comlst))
                  (setq num (1+ num))
                  (if (= (car sub) lispnm)
                      (progn
                           (setq found t)
                           (setq sub (list (car sub)
                                           (itoa (1+ (read (cadr sub))))))))
 ; Ŀ
 ;   Add all lists to the new master list.                                 
 ; 
                  (setq gnulst (cons sub gnulst)))
 ; Ŀ
 ;   If the lisp name wasn't found, add it.                                
 ; 
           (if (null found)
               (setq gnulst (append gnulst (list (list lispnm "1"))))))
 ; Ŀ
 ;   If the file was empty, make a new list containing the lisp name.      
 ; 
      (setq gnulst (list (list lispnm "1"))))
 ; Ŀ
 ;   Sort the new list by number (second element) and then alphabetically  
 ;   (first element).                                                      
 ; 
  (setq gnulst (sohrt gnulst))
 ; Ŀ
 ;   Write the list to the file.                                           
 ; 
  (bulla gnulst filnam)
 (princ))
 ; Ŀ
 ;   Trende end.                                                           
 ; 

 ; Ŀ
 ;   Rloadt - Rload with Trending.  Note that this loads as Rload to       
 ;   allow either of the two preload files Rload and Rloadt to be used.    
 ; 
 ; Ŀ
 ;   Note that the lisp name will only be written to the log file the      
 ;   first time it is run - after that the full definition is loaded and   
 ;   the logging code is replaced.                                         
 ;   This also means that if several routines are stored in the same       
 ;   file, running one loads all of them, so only the first one run will   
 ;   be logged.  But shouldn't it be possible to add the logging code to   
 ;   the real function after it is loaded?                                 
 ;   No: defun-q produces a list, but defun doesn't any longer - the       
 ;   last rewrite removed the heart of autolisp.                           
 ;   So can defun-q be used with impunity?                                 
 ;   Possibly this could be done with reactors...                          
 ; 
 (DEFUN RLOAD (filnam lsplst / lspnam)
  (while (setq lspnam (car lsplst))
         (setq lsplst (cdr lsplst))
         (eval (list 'defun (read (strcat "C:" lspnam)) ()
                            (list load filnam)
                            (list trende lspnam)
                            (read (strcat "(C:" lspnam ")")))))
 (princ))
 ; Ŀ
 ;   Rloadt end.                                                           
 ; 
